<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if (! class_exists ( 'OneKorsePlusHeaderPostType' ) ) {

	class OneKorsePlusHeaderPostType {

        private static $_instance = null;

        public static function instance() {
            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }

            return self::$_instance;
        }

		function __construct() {

			add_action ( 'init', array( $this, 'onekorse_register_cpt' ), 5 );
			add_filter ( 'template_include', array ( $this, 'onekorse_template_include' ) );
		}

		function onekorse_register_cpt() {

			$labels = array (
				'name'				 => __( 'Headers', 'onekorse-plus' ),
				'singular_name'		 => __( 'Header', 'onekorse-plus' ),
				'menu_name'			 => __( 'Headers', 'onekorse-plus' ),
				'add_new'			 => __( 'Add Header', 'onekorse-plus' ),
				'add_new_item'		 => __( 'Add New Header', 'onekorse-plus' ),
				'edit'				 => __( 'Edit Header', 'onekorse-plus' ),
				'edit_item'			 => __( 'Edit Header', 'onekorse-plus' ),
				'new_item'			 => __( 'New Header', 'onekorse-plus' ),
				'view'				 => __( 'View Header', 'onekorse-plus' ),
				'view_item' 		 => __( 'View Header', 'onekorse-plus' ),
				'search_items' 		 => __( 'Search Headers', 'onekorse-plus' ),
				'not_found' 		 => __( 'No Headers found', 'onekorse-plus' ),
				'not_found_in_trash' => __( 'No Headers found in Trash', 'onekorse-plus' ),
			);

			$args = array (
				'labels' 				=> $labels,
				'public' 				=> true,
				'exclude_from_search'	=> true,
				'show_in_nav_menus' 	=> false,
				'show_in_rest' 			=> true,
				'menu_position'			=> 25,
				'menu_icon' 			=> 'dashicons-heading',
				'hierarchical' 			=> false,
				'supports' 				=> array ( 'title', 'editor', 'revisions' ),
			);

			register_post_type ( 'wdt_headers', $args );
		}

		function onekorse_template_include($template) {
			if ( is_singular( 'wdt_headers' ) ) {
				if ( ! file_exists ( get_stylesheet_directory () . '/single-wdt_headers.php' ) ) {
					$template = ONEKORSE_PLUS_DIR_PATH . 'post-types/templates/single-wdt_headers.php';
				}
			}

			return $template;
		}
	}
}

OneKorsePlusHeaderPostType::instance();