<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class WeDesignTech_Widget_Base_Donations {

	private static $_instance = null;

	private $cc_layout;
	private $cc_style;

	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	function __construct() {

		// Initialize depandant class
			$this->cc_layout = new WeDesignTech_Common_Controls_Layout('both');
			$this->cc_style = new WeDesignTech_Common_Controls_Style();

	}

	public function name() {
		return 'wdt-donations';
	}

	public function title() {
		return esc_html__( 'Donations', 'wdt-elementor-addon' );
	}

	public function icon() {
		return 'eicon-apps';
	}

	public function init_styles() {
		return array_merge(
			$this->cc_layout->init_styles(),
			array (
                'wdt-progress-bar' =>  WEDESIGNTECH_ELEMENTOR_ADDON_DIR_URL.'inc/widgets/progress-bar/assets/css/style.css',
				$this->name() =>  WEDESIGNTECH_ELEMENTOR_ADDON_DIR_URL.'inc/widgets/donations/assets/css/style.css'
			)
		);
	}

	public function init_inline_styles() {
		if(!\Elementor\Plugin::$instance->preview->is_preview_mode()) {
			return array (
				$this->name() => $this->cc_layout->get_column_css()
			);
		}
		return array ();
	}

	public function init_scripts() {
		return array_merge(
			$this->cc_layout->init_scripts(),
			array (
                'jquery-progress-bar' => WEDESIGNTECH_ELEMENTOR_ADDON_DIR_URL . 'inc/widgets/donations/assets/js/progressbar.min.js',
                $this->name() =>  WEDESIGNTECH_ELEMENTOR_ADDON_DIR_URL.'inc/widgets/donations/assets/js/script.js'
            )
		);
	}

	public function create_elementor_controls($elementor_object) {

		$elementor_object->start_controls_section( 'wdt_section_settings', array(
			'label' => esc_html__( 'Donations Settings', 'wdt-elementor-addon'),
		) );

			$elementor_object->add_control( 'limit', array(
				'label'   => esc_html__('Limit', 'wdt-elementor-addon'),
				'type'    => \Elementor\Controls_Manager::SLIDER,
				'range'   => array(
					'px' => array( 'min' => 1, 'max' => 10, 'step' => 1 )
				),
				'separator' => 'before',
				'default' => array(
					'size' => 4
				)
        	) );

            $elementor_object->add_control( 'single_page_link', array(
                'label'   => esc_html__( 'Single Page Link', 'wdt-elementor-addon' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => array(
                    ''  => esc_html__( 'Default', 'wdt-elementor-addon' ),
                    'custom_redirection' => esc_html__( 'Custom Redirection', 'wdt-elementor-addon' )
                )
            ));

		$elementor_object->end_controls_section();

		$this->cc_layout->get_controls($elementor_object);



		$elementor_object->start_controls_section( 'wdt_style_section_bar', array(
        	'label'      => esc_html__( 'Bar', 'wdt-elementor-addon' ),
			'tab'        => \Elementor\Controls_Manager::TAB_STYLE
		) );

			$elementor_object->add_control(
				'bar_active_thickness',
				array (
					'label' => esc_html__( 'Active Thickeness', 'wdt-elementor-addon' ),
					'type' => \Elementor\Controls_Manager::NUMBER,
					'min' => 0.1,
					'max' => 100,
					'step' => 0.1,
					'default' => 2
				)
			);

			$elementor_object->add_control(
				'bar_inactive_thickness',
				array (
					'label' => esc_html__( 'Inactive Thickeness', 'wdt-elementor-addon' ),
					'type' => \Elementor\Controls_Manager::NUMBER,
					'min' => 0.1,
					'max' => 100,
					'step' => 0.1,
					'default' => 2
				)
			);

			$elementor_object->add_control(
				'bar_active_color',
				array (
					'label' => esc_html__( 'Active Color', 'wdt-elementor-addon' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'default' => wedesigntech_elementor_global_colors( 'system_colors', 0 ),
					'global' => array (
						'active' => false,
					)
				)
			);

			$elementor_object->add_control(
				'bar_inactive_color',
				array (
					'label' => esc_html__( 'Inactive Color', 'wdt-elementor-addon' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'default' => wedesigntech_elementor_global_colors( 'system_colors', 2 ),
					'global' => array (
						'active' => false,
					)
				)
			);

            $elementor_object->add_control(
				'enable_gradient',
				array(
					'label'              => esc_html__( 'Enable Gradient', 'wdt-elementor-addon' ),
					'type'               => \Elementor\Controls_Manager::SWITCHER,
					'frontend_available' => true,
					'default'            => '',
					'return_value'       => 'true'
				)
			);

			$elementor_object->add_control(
				'gradient_color',
				array (
					'label' => esc_html__( 'Gradient Color', 'wdt-elementor-addon' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'global' => array (
						'active' => false,
					),
					'default' => wedesigntech_elementor_global_colors( 'system_colors', 3 ),
					'condition' => array(
						'enable_gradient' => 'true'
					)
				)
			);

		$elementor_object->end_controls_section();

	}

    public function get_attributes($settings) {

        $bar_settings = array();
		$bar_settings['module_id'] = $settings['module_id'];
        $bar_settings['bar_active_thickness'] = $settings['bar_active_thickness'];
		$bar_settings['bar_inactive_thickness'] = $settings['bar_inactive_thickness'];
		$bar_settings['bar_active_color'] = !empty($settings['bar_active_color']) ? $settings['bar_active_color'] : '';
		$bar_settings['bar_inactive_color'] = !empty($settings['bar_inactive_color']) ? $settings['bar_inactive_color'] : '';
        $bar_settings_attr = wp_json_encode($bar_settings);

        return $bar_settings_attr;

    }

	public function render_html($widget_object, $settings) {

		if($widget_object->widget_type != 'elementor') {
			return;
		}

		$output = '';

		$classes = array ();

        $settings['module_id'] = $widget_object->get_id();
        $settings['module_class'] = 'donations';
        $settings['classes'] = $classes;

        $bar_settings = array();
		$bar_settings['module_id'] = $settings['module_id'];
        $bar_settings['bar_active_thickness'] = $settings['bar_active_thickness'];
		$bar_settings['bar_inactive_thickness'] = $settings['bar_inactive_thickness'];
		$bar_settings['bar_active_color'] = !empty($settings['bar_active_color']) ? $settings['bar_active_color'] : '';
		$bar_settings['bar_inactive_color'] = !empty($settings['bar_inactive_color']) ? $settings['bar_inactive_color'] : '';
        $bar_settings['enable_gradient'] = (isset($settings['enable_gradient']) && $settings['enable_gradient'] == 'true') ? true : false;
		$bar_settings['gradient_color'] = !empty($settings['gradient_color']) ? $settings['gradient_color'] : '';

        $settings['custom_attributes'] = $bar_settings;

        $this->cc_layout->set_settings($settings);
        $module_layout_class = $this->cc_layout->get_item_class();


        // Arguments to only fetch forms with goal enabled.
        $form_args = array(
            'post_type'      => 'give_forms',
            'post_status'    => 'publish',
            'posts_per_page' => (isset($settings['limit']['size']) && !empty($settings['limit']['size'])) ? $settings['limit']['size'] : 4,
            'orderby'        => 'date',
            'order'          => 'ASC',
            'meta_key'       => '_give_goal_option',
            'meta_value'     => 'enabled',
        );

        // Query to output donation forms.
        $form_query = new WP_Query( $form_args );

        if ( $form_query->have_posts() ) {
            $output .= $this->cc_layout->get_wrapper_start();
                while ( $form_query->have_posts() ) {

                    $form_query->the_post();

                    $donation_id = get_the_ID();
                    $donation_permalink = get_the_permalink();
                    $donation_title = get_the_title();

                    $goal_stats = give_goal_progress_stats( $donation_id );

                    if($settings['single_page_link'] == 'custom_redirection') {
                        $page_link = get_post_meta($donation_id, '_give_form_grid_redirect_url', true);
                        $page_link = (isset($page_link) && !empty($page_link)) ? $page_link : '#';
                    } else {
                        $page_link = get_permalink($donation_id);
                    }

                    $output .= '<div class="'.esc_attr($module_layout_class).'">';
						$output .= '<div class="wdt-donation-item">';
							if(has_post_thumbnail($donation_id)) {
								$output .= '<div class="wdt-donation-item-media">';
									$output .= get_the_post_thumbnail($donation_id, 'full', array ('title' => $donation_title));
								$output .= '</div>';
							}
							$output .= '<div class="wdt-donation-item-detail">';
								$output .= '<h4 class="wdt-donation-item-title"><a href="'.esc_url($page_link).'">'.$donation_title.'</a></h4>';
								$output .= '<p class="wdt-donation-item-description">'.get_the_excerpt().'</p>';
								$output .= '<div class="wdt-donation-item-fund-details">';
									$output .= '<div class="wdt-progressbar-container wdt-progressbar-horizontal wdt-progressbar-content-default" id="wdt-progressbar-'.esc_attr($donation_id).'" data-donation-id="'.esc_attr($donation_id).'"  data-percentage="'.esc_js($goal_stats['progress']).'">';
										$output .= '<div class="wdt-progressbar-content">';
											$output .= esc_html__('Fund raised', 'wdt-elementor-addon');
											$output .= '<div class="wdt-progressbar-value"></div>';
										$output .= '</div>';
										$output .= '<div class="wdt-progressbar"></div>';
									$output .= '</div>';
								$output .= '</div>';
								$output .= '<a href="'.esc_url($page_link).'" class="wdt-donation-item-button button">'.esc_html__('Donate Now', 'wdt-elementor-addon').'<svg class="icon-arrow-aft-btn" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
								viewBox="0 0 100 63" style="enable-background:new 0 0 100 63;" xml:space="preserve">
						   <polygon style="fill:currentColor;" points="63.2,6.3 84.3,27.4 -77.1,27.4 -77.1,35.6 84.3,35.6 63.2,56.7 69,62.5 100,31.5 69,0.5 "/>
						   </svg></a>';
							$output .= '</div>';
						$output .= '</div>';
                    $output .= '</div>';

                }
                wp_reset_postdata();
                $output .= $this->cc_layout->get_column_edit_mode_css();
            $output .= $this->cc_layout->get_wrapper_end();
        }

		return $output;

	}

}

if( !function_exists( 'wedesigntech_widget_base_donations' ) ) {
    function wedesigntech_widget_base_donations() {
        return WeDesignTech_Widget_Base_Donations::instance();
    }
}