<?php
if (!class_exists ( 'DTLMSCustomPostTypes' )) {

	class DTLMSCustomPostTypes {

		/**
		 * Instance variable
		 */
		private static $_instance = null;

		/**
		 * Instance
		 *
		 * Ensures only one instance of the class is loaded or can be loaded.
		 */
		public static function instance() {

			if ( is_null( self::$_instance ) ) {
				self::$_instance = new self();
			}

			return self::$_instance;
		}

		function __construct() {

			/* Courses Custom Post Type */
			require_once DTLMS_PLUGIN_PATH . 'custom-post-types/courses-post-type.php';

			/* Lesson Custom Post Type */
			require_once DTLMS_PLUGIN_PATH . 'custom-post-types/lessons-post-type.php';

			/* Grading Custom Post Type */
			require_once DTLMS_PLUGIN_PATH . 'custom-post-types/gradings-post-type.php';
			if (class_exists ( 'DTLMSGradingsPostType' )) {
				new DTLMSGradingsPostType ();
			}

			/* Packages Custom Post Type */
			require_once DTLMS_PLUGIN_PATH . 'custom-post-types/packages-post-type.php';
			if (class_exists ( 'DTLMSPackagesPostType' )) {
				new DTLMSPackagesPostType ();
			}

			/* Commission payments Custom Post Type */
			require_once DTLMS_PLUGIN_PATH . 'custom-post-types/commissionpayments-post-type.php';
			if (class_exists ( 'DTLMSCommissionPaymentsPostType' )) {
				new DTLMSCommissionPaymentsPostType ();
			}

			/* Author Single Page */
			add_filter ( 'template_include', array ( $this, 'dtlms_template_include'  ) );

			add_filter ( 'template_include', array ( $this, 'dtlms_author_single_template'  ) );

		}

		function dtlms_template_include($template) {

			if(is_author()) {
				$template = DTLMS_PLUGIN_PATH . 'custom-post-types/templates/single-author.php';
				//$template = DTLMS_PLUGIN_PATH . 'custom-post-types/templates/author-single.php';
				
			}

			return $template;

		}

		function dtlms_author_single_template($templates){

			

			global $post;
				$id = get_the_ID();
				$file = get_post_meta($id, '_wp_page_template', true);
					if ('author-single.php' == $file){
						$templates = DTLMS_PLUGIN_PATH . 'custom-post-types/templates/author-single.php';
					}
			return $templates;
		}
	}

	DTLMSCustomPostTypes::instance();

}


?>