<?php
class OneKorse_Widget_Related_Courses extends WP_Widget {
	#1.constructor
	function __construct() {
		$widget_options = array(
			'classname'   => 'widget_related_courses',
			'description' => esc_html__('To list out courses', 'dtlms')
		);

        $theme_name =  defined('ONEKORSE_THEME_NAME') ? ONEKORSE_THEME_NAME : 'OneKorse';
		parent::__construct( false, $theme_name . esc_html__(' Related Courses','dtlms'), $widget_options );
	}

	#2.widget input form in back-end
	function form($instance) {
		$instance = wp_parse_args( (array) $instance, array(
			'title'            => '',
			'_course_count'      => '',
			'_course_categories' => '',
			'_enabled_image'   => '',
			'_excerpt'         => ''
		) );

		$title            = strip_tags($instance['title']);
		$_course_count      = !empty($instance['_course_count']) ? strip_tags($instance['_course_count']) : "-1";
		$_course_categories = !empty($instance['_course_categories']) ? $instance['_course_categories']: array();
		$_enabled_image   = isset($instance['_enabled_image']) ? (bool) $instance['_enabled_image'] : false;
		$_excerpt         = !empty($instance['_excerpt']) ? $instance['_excerpt'] : 'show title only';?>

        <!-- Form -->
        <p>
        	<label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
        		<?php esc_html_e('Title:','dtlms');?>
        		<input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>"/>
			</label>
		</p>

	    <p>
	    	<label for="<?php echo esc_attr($this->get_field_id('_course_categories')); ?>">
	    		<?php esc_html_e('Choose the categories you want to display (multiple selection possible)','dtlms');?>
	    	</label>
            <select class="widefat" id="<?php echo esc_attr($this->get_field_id('_course_categories').'[]');?>" name="<?php echo esc_attr($this->get_field_name('_course_categories').'[]');?>" multiple="multiple">
            	<option value=""><?php esc_html_e("Select",'dtlms');?></option><?php
            	$cats = get_terms('course_category');
            	foreach ($cats as $cat):
					$id       = esc_attr($cat->term_id);
					$selected = ( in_array($id,$_course_categories)) ? 'selected="selected"' : '';
					$title    = esc_html($cat->name);?>
        			<option <?php echo esc_attr($selected);?> value="<?php echo esc_attr($id);?>"><?php echo esc_attr($title);?></option><?php
				endforeach;?>
            </select>
        </p>

        <p>
        	<label for="<?php echo esc_attr($this->get_field_id('_excerpt')); ?>">
        		<?php esc_html_e('Display title only or title &amp; excerpt','dtlms');?>
        	</label>
        	<select class="widefat" id="<?php echo esc_attr($this->get_field_id('_excerpt')); ?>" name="<?php echo esc_attr($this->get_field_name('_excerpt')); ?>"><?php
        		$answers = array('show title only','show title and excerpt');
		   		foreach ($answers  as $answer ):
		   			$selected = ($_excerpt == $answer ) ? "selected='selected'" : "";?>
		   			<option <?php echo esc_attr($selected);?> value="<?php echo esc_attr($answer);?>"><?php echo esc_attr($answer);?></option><?php
		   		endforeach;?>
           </select>
        </p>

        <p>
        	<input type="checkbox" id="<?php echo esc_attr($this->get_field_id('_enabled_image'));?>" name="<?php echo esc_attr($this->get_field_name('_enabled_image'));?>" <?php checked($_enabled_image);?>/>
        	<?php esc_html_e("Show Image",'dtlms');?>
        </p>

	    <p>
	    	<label for="<?php echo esc_attr($this->get_field_id('_course_count'));?>">
	    		<?php esc_html_e('No.of posts to show:','dtlms');?>
	    	</label>
		    <input id="<?php echo esc_attr($this->get_field_id('_course_count')); ?>" name="<?php echo esc_attr($this->get_field_name('_course_count')); ?>" value="<?php echo esc_attr($_course_count);?>"/>
		</p><!-- Form end--><?php
	}

	#3.processes & saves the twitter widget option
	function update( $new_instance,$old_instance ) {
		$instance = $old_instance;

		$instance['title']            = strip_tags($new_instance['title']);
		$instance['_course_count']      = strip_tags($new_instance['_course_count']);
		$instance['_course_categories'] = $new_instance['_course_categories'];
		$instance['_excerpt']         = $new_instance['_excerpt'];
		$instance['_enabled_image']   = !empty($new_instance['_enabled_image']) ? 1 : 0;

		return $instance;
	}

	#4.output in front-end
	function widget($args, $instance) {
		extract($args);

		global $post;

		$title            = empty($instance['title']) ?	'' : strip_tags($instance['title']);
		$_course_count      = (int) $instance['_course_count'];

		$_course_categories = "";
		if(!empty($instance['_course_categories']) ) {
			$_course_categories = is_array($instance['_course_categories']) ? implode(",",$instance['_course_categories']) : $instance['_course_categories'];
		}

		$_enabled_image = isset($instance['_enabled_image']) ? $instance['_enabled_image']:0;
		$show_title     = ($instance['_excerpt'] == 'show title only') ? (bool) true : (bool) false;

		
		$arg = array (
			'orderby' => 'rand',
			'showposts' => '3',
			'post_status' => 'publish',
			'post__not_in' => array ($course_id),
			'tax_query' => array (
							array (
								'taxonomy' => 'course_category',
								'field' => 'id',
								'operator' => 'IN',
								'terms' => $_course_categories
							)
						)
			);
		echo onekorse_pro_before_after_widget( $before_widget );

		if( !empty( $title ) ) {

			echo onekorse_pro_widget_title( $before_title . $title . $after_title );
		}

		echo "<div class='related-courses-widget'><ul>";
			 $the_query = new WP_Query($arg);
			 if( $the_query->have_posts() ) :
			 while( $the_query->have_posts() ):
			 	$the_query->the_post();
				$title = get_the_title();
				echo "<li>";
					if(1 == $_enabled_image):
						$image = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'thumbnail', false);
						$image = ( $image != false)? $image[0] : ONEKORSE_PRO_DIR_URL . 'modules/blog/assets/images/post-thumb.jpg';
						echo "<div class='entry-image'><a href='".get_permalink()."' class='thumb'>";
							echo "<img src='{$image}' alt='".the_title_attribute('echo=0')."'>";
						echo "</a></div>";
					endif;

					if($show_title):
						echo "<div class='entry-title'><h4><a href='".get_permalink()."'>{$title}</a></h4></div>";
					else:
						echo "<div class='entry-title'><h4><a href='".get_permalink()."'>{$title}</a></h4></div>";
						echo "<div class='entry-content'>".onekorse_excerpt(10)."</div>";
					endif;

					$product = dtlms_get_product_object($post->ID);
					$woo_price = dtlms_get_item_price_html($product);

					$free_course = false;
					if($woo_price == '') {
						$free_course = true;
					}

					echo dtlms_course_listing_single_price($purchased_paid_course, $free_course, $woo_price); 

				echo "</li>";
			 endwhile;
			 else:
			 	echo "<li><h4>".esc_html__('No Posts found','dtlms')."</h4></li>";
			 endif;
			 wp_reset_postdata();
	 	echo "</ul></div>";

		echo onekorse_pro_before_after_widget( $after_widget );
	}
}?>