<?php
add_action( 'onekorse_after_main_css', 'comment_style' );
function comment_style() {
    if ( (class_exists( 'WooCommerce' ) && is_product()) || ( is_singular('post') || is_singular('page') || is_attachment() ) && get_option( 'thread_comments' ) ) {
        wp_enqueue_style( 'onekorse-comments', get_theme_file_uri('/modules/comments/assets/css/comments.css'), false, ONEKORSE_THEME_VERSION, 'all');
    }
}

if( ! function_exists('include_comments_template') ) {
    function include_comments_template() {
        echo '<section class="commententries rounded">';
            comments_template();
        echo '</section>';
    }

    add_action( 'onekorse_after_single_page_content_wrap', 'include_comments_template' );
}

if( ! function_exists( 'load_comments_template' )  ) {
	function load_comments_template() {
		onekorse_template_part( 'comments', 'templates/comments' );
	}

	add_action( 'onekorse_comments_template', 'load_comments_template' );
}

if(!function_exists('onekorse_privacy_comment_checkbox_default')) {
	function onekorse_privacy_comment_checkbox_default( $comment_field ) {

		$cookie_field = '';
		if(!empty($comment_field['cookies'])) {
			$cookie_field = $comment_field['cookies'];
			unset($comment_field['cookies']);
		}
		unset($comment_field['url']);


		$comment_field['author'] = '<div class="wdt-column wdt-one-half first">
										<p>
											<input id="author" name="author" type="text" placeholder ="Your Name" required />
										</p>
									</div>';

		$comment_field['email'] = '<div class="wdt-column wdt-one-half">
										<p>
											<input id="email" name="email" type="text" placeholder ="Your Email" required />
										</p>
									</div>';

		if($cookie_field != '') {
			$comment_field['cookies'] =  $cookie_field;
		}

		return $comment_field;

	}
	add_filter( 'comment_form_default_fields', 'onekorse_privacy_comment_checkbox_default'  );
}

function onekorse_modify_comment_form_text_area($arg) {
    $arg['comment_field'] = '<div class="wdt-column wdt-one-column comment-box">
								<p class="comment-form-comment">
									<textarea id="comment" name="comment" cols="45" rows="1" placeholder="Comment" aria-required="true"></textarea>
								</p>
							</div>';
    return $arg;
}

add_filter('comment_form_defaults', 'onekorse_modify_comment_form_text_area');



if(!function_exists('onekorse_move_comment_field_to_bottom')) {

	function onekorse_move_comment_field_to_bottom( $fields ) {

		if(is_singular('dtlms_classes') || is_singular('dtlms_courses') || is_singular('post')) {
			$comment_field = $fields['comment'];
			$cookies_field = $fields['cookies'];
			unset( $fields['comment'] );
			unset( $fields['cookies'] );
			$fields['comment'] = $comment_field;
			$fields['cookies'] = $cookies_field;
		}
		return $fields;

	}

	add_filter( 'comment_form_fields', 'onekorse_move_comment_field_to_bottom' );

}






