<?php

/**
 * Listing Options - Product Thumb Content
 */


if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if( !class_exists( 'OneKorse_Woo_Listing_Option_Content_Content' ) ) {

    class OneKorse_Woo_Listing_Option_Content_Content extends OneKorse_Woo_Listing_Option_Core {

        private static $_instance = null;

        public $option_slug;

        public $option_name;

        public $option_type;

        public $option_default_value;

        public $option_value_prefix;

        public static function instance() {

            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }

            return self::$_instance;

        }

        function __construct() {

            $this->option_slug          = 'product-content-content';
            $this->option_name          = esc_html__('Content Elements', 'onekorse');
            $this->option_type          = array ( 'html', 'value-css' );
            $this->option_default_value = '';
            $this->option_value_prefix  = '';

            $this->render_backend();
        }

        /**
         * Backend Render
         */
        function render_backend() {

            /* Custom Product Templates - Options */
            add_filter( 'onekorse_woo_custom_product_template_content_options', array( $this, 'woo_custom_product_template_content_options'), 10, 1 );
        }

        /**
         * Custom Product Templates - Options
         */
        function woo_custom_product_template_content_options( $template_options ) {

            array_push( $template_options, $this->setting_args() );

            return $template_options;
        }

        /**
         * Settings Group
         */
        function setting_group() {
            return 'content';
        }

        /**
         * Setting Arguments
         */
        function setting_args() {

            $settings            =  array ();
            $settings['id']      =  $this->option_slug;
            $settings['type']    =  'sorter';
            $settings['title']   =  $this->option_name;
            $settings['default'] =  array (
                'enabled'            => array(
                    'title'          => esc_html__('Title', 'onekorse'),
                    'category'       => esc_html__('Category', 'onekorse'),
                    'price'          => esc_html__('Price', 'onekorse'),
                    'button_element' => esc_html__('Button Element', 'onekorse'),
                    'icons_group'    => esc_html__('Icons Group', 'onekorse'),
                ),
                'disabled'         => array(
                    'excerpt'       => esc_html__('Excerpt', 'onekorse'),
                    'rating'        => esc_html__('Rating', 'onekorse'),
                    'countdown'     => esc_html__('Count Down', 'onekorse'),
                    'separator'     => esc_html__('Separator', 'onekorse'),
                    'element_group' => esc_html__('Element Group', 'onekorse'),
                    'product_notes' => esc_html__('Product Notes', 'onekorse'),
                    'label_instock' => esc_html__('Label - InStock', 'onekorse')
                ),
            );



            return $settings;
        }
    }

}

if( !function_exists('onekorse_woo_listing_option_content_content') ) {
	function onekorse_woo_listing_option_content_content() {
		return OneKorse_Woo_Listing_Option_Content_Content::instance();
	}
}

onekorse_woo_listing_option_content_content();