<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if( !class_exists( 'OneKorse_Shop_Metabox_Single_Upsell_Related' ) ) {
    class OneKorse_Shop_Metabox_Single_Upsell_Related {

        private static $_instance = null;

        public static function instance() {
            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }

            return self::$_instance;
        }

        function __construct() {

			add_filter( 'onekorse_shop_product_custom_settings', array( $this, 'onekorse_shop_product_custom_settings' ), 10 );

		}

        function onekorse_shop_product_custom_settings( $options ) {

			$ct_dependency      = array ();
			$upsell_dependency  = array ( 'show-upsell', '==', 'true');
			$related_dependency = array ( 'show-related', '==', 'true');
			if( function_exists('onekorse_shop_single_module_custom_template') ) {
				$ct_dependency['dependency'] 	= array ( 'product-template', '!=', 'custom-template');
				$upsell_dependency 				= array ( 'product-template|show-upsell', '!=|==', 'custom-template|true');
				$related_dependency 			= array ( 'product-template|show-related', '!=|==', 'custom-template|true');
			}

			$product_options = array (

				array_merge (
					array(
						'id'         => 'show-upsell',
						'type'       => 'select',
						'title'      => esc_html__('Show Upsell Products', 'onekorse'),
						'class'      => 'chosen',
						'default'    => 'admin-option',
						'attributes' => array( 'data-depend-id' => 'show-upsell' ),
						'options'    => array(
							'admin-option' => esc_html__( 'Admin Option', 'onekorse' ),
							'true'         => esc_html__( 'Show', 'onekorse'),
							null           => esc_html__( 'Hide', 'onekorse'),
						)
					),
					$ct_dependency
				),

				array(
					'id'         => 'upsell-column',
					'type'       => 'select',
					'title'      => esc_html__('Choose Upsell Column', 'onekorse'),
					'class'      => 'chosen',
					'default'    => 4,
					'options'    => array(
						'admin-option' => esc_html__( 'Admin Option', 'onekorse' ),
						1              => esc_html__( 'One Column', 'onekorse' ),
						2              => esc_html__( 'Two Columns', 'onekorse' ),
						3              => esc_html__( 'Three Columns', 'onekorse' ),
						4              => esc_html__( 'Four Columns', 'onekorse' ),
					),
					'dependency' => $upsell_dependency
				),

				array(
					'id'         => 'upsell-limit',
					'type'       => 'select',
					'title'      => esc_html__('Choose Upsell Limit', 'onekorse'),
					'class'      => 'chosen',
					'default'    => 4,
					'options'    => array(
						'admin-option' => esc_html__( 'Admin Option', 'onekorse' ),
						1              => esc_html__( 'One', 'onekorse' ),
						2              => esc_html__( 'Two', 'onekorse' ),
						3              => esc_html__( 'Three', 'onekorse' ),
						4              => esc_html__( 'Four', 'onekorse' ),
						5              => esc_html__( 'Five', 'onekorse' ),
						6              => esc_html__( 'Six', 'onekorse' ),
						7              => esc_html__( 'Seven', 'onekorse' ),
						8              => esc_html__( 'Eight', 'onekorse' ),
						9              => esc_html__( 'Nine', 'onekorse' ),
						10              => esc_html__( 'Ten', 'onekorse' ),
					),
					'dependency' => $upsell_dependency
				),

				array_merge (
					array(
						'id'         => 'show-related',
						'type'       => 'select',
						'title'      => esc_html__('Show Related Products', 'onekorse'),
						'class'      => 'chosen',
						'default'    => 'admin-option',
						'attributes' => array( 'data-depend-id' => 'show-related' ),
						'options'    => array(
							'admin-option' => esc_html__( 'Admin Option', 'onekorse' ),
							'true'         => esc_html__( 'Show', 'onekorse'),
							null           => esc_html__( 'Hide', 'onekorse'),
						)
					),
					$ct_dependency
				),

				array(
					'id'         => 'related-column',
					'type'       => 'select',
					'title'      => esc_html__('Choose Related Column', 'onekorse'),
					'class'      => 'chosen',
					'default'    => 4,
					'options'    => array(
						'admin-option' => esc_html__( 'Admin Option', 'onekorse' ),
						2              => esc_html__( 'Two Columns', 'onekorse' ),
						3              => esc_html__( 'Three Columns', 'onekorse' ),
						4              => esc_html__( 'Four Columns', 'onekorse' ),
					),
					'dependency' => $related_dependency
				),

				array(
					'id'         => 'related-limit',
					'type'       => 'select',
					'title'      => esc_html__('Choose Related Limit', 'onekorse'),
					'class'      => 'chosen',
					'default'    => 4,
					'options'    => array(
						'admin-option' => esc_html__( 'Admin Option', 'onekorse' ),
						1              => esc_html__( 'One', 'onekorse' ),
						2              => esc_html__( 'Two', 'onekorse' ),
						3              => esc_html__( 'Three', 'onekorse' ),
						4              => esc_html__( 'Four', 'onekorse' ),
						5              => esc_html__( 'Five', 'onekorse' ),
						6              => esc_html__( 'Six', 'onekorse' ),
						7              => esc_html__( 'Seven', 'onekorse' ),
						8              => esc_html__( 'Eight', 'onekorse' ),
						9              => esc_html__( 'Nine', 'onekorse' ),
						10              => esc_html__( 'Ten', 'onekorse' ),
					),
					'dependency' => $related_dependency
				)

			);

			$options = array_merge( $options, $product_options );

			return $options;

		}

    }
}

OneKorse_Shop_Metabox_Single_Upsell_Related::instance();