<?php

/**
 * WooCommerce - Single - Module - Social Share & Follow - Customizer Settings
 */


if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if( !class_exists( 'OneKorse_Shop_Customizer_Single_Social_Share_And_Follow' ) ) {

    class OneKorse_Shop_Customizer_Single_Social_Share_And_Follow {

        private static $_instance = null;

        public static function instance() {

            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }

            return self::$_instance;

        }

        function __construct() {

            add_filter( 'onekorse_woo_single_page_settings', array( $this, 'single_page_settings' ), 10, 1 );
            add_action( 'customize_register', array( $this, 'register' ), 15);

        }

        function single_page_settings( $settings ) {

            $product_show_sharer_facebook                = onekorse_customizer_settings('wdt-single-product-show-sharer-facebook' );
            $settings['product_show_sharer_facebook']    = $product_show_sharer_facebook;

            $product_show_sharer_delicious               = onekorse_customizer_settings('wdt-single-product-show-sharer-delicious' );
            $settings['product_show_sharer_delicious']   = $product_show_sharer_delicious;

            $product_show_sharer_digg                    = onekorse_customizer_settings('wdt-single-product-show-sharer-digg' );
            $settings['product_show_sharer_digg']        = $product_show_sharer_digg;

            $product_show_sharer_twitter                 = onekorse_customizer_settings('wdt-single-product-show-sharer-twitter' );
            $settings['product_show_sharer_twitter']     = $product_show_sharer_twitter;

            $product_show_sharer_linkedin                = onekorse_customizer_settings('wdt-single-product-show-sharer-linkedin' );
            $settings['product_show_sharer_linkedin']    = $product_show_sharer_linkedin;

            $product_show_sharer_pinterest               = onekorse_customizer_settings('wdt-single-product-show-sharer-pinterest' );
            $settings['product_show_sharer_pinterest']   = $product_show_sharer_pinterest;

            return $settings;

        }

        function register( $wp_customize ) {

            /**
            * Share
            */

                /**
                * Option : Sharer Description
                */
                    $wp_customize->add_setting(
                        ONEKORSE_CUSTOMISER_VAL . '[wdt-single-product-show-sharer-description]', array(
                            'type' => 'option'
                        )
                    );

                    $wp_customize->add_control(
                        new OneKorse_Customize_Control_Switch(
                            $wp_customize, ONEKORSE_CUSTOMISER_VAL . '[wdt-single-product-show-sharer-description]', array(
                                'type'        => 'wdt-description',
                                'label'       => esc_html__( 'Note: ', 'onekorse-pro'),
                                'section'     => 'woocommerce-single-page-sociable-share-section',
                                'description' => esc_html__( 'This option is applicable only for WooCommerce "Custom Template".', 'onekorse-pro')
                            )
                        )
                    );

                /**
                * Option : Show Facebook Sharer
                */
                    $wp_customize->add_setting(
                        ONEKORSE_CUSTOMISER_VAL . '[wdt-single-product-show-sharer-facebook]', array(
                            'type' => 'option'
                        )
                    );

                    $wp_customize->add_control(
                        new OneKorse_Customize_Control_Switch(
                            $wp_customize, ONEKORSE_CUSTOMISER_VAL . '[wdt-single-product-show-sharer-facebook]', array(
                                'type'    => 'wdt-switch',
                                'label'   => esc_html__( 'Show Facebook Sharer', 'onekorse-pro'),
                                'section' => 'woocommerce-single-page-sociable-share-section',
                                'choices' => array(
                                    'on'  => esc_attr__( 'Yes', 'onekorse-pro' ),
                                    'off' => esc_attr__( 'No', 'onekorse-pro' )
                                )
                            )
                        )
                    );

                /**
                * Option : Show Delicious Sharer
                */
                    $wp_customize->add_setting(
                        ONEKORSE_CUSTOMISER_VAL . '[wdt-single-product-show-sharer-delicious]', array(
                            'type' => 'option'
                        )
                    );

                    $wp_customize->add_control(
                        new OneKorse_Customize_Control_Switch(
                            $wp_customize, ONEKORSE_CUSTOMISER_VAL . '[wdt-single-product-show-sharer-delicious]', array(
                                'type'    => 'wdt-switch',
                                'label'   => esc_html__( 'Show Delicious Sharer', 'onekorse-pro'),
                                'section' => 'woocommerce-single-page-sociable-share-section',
                                'choices' => array(
                                    'on'  => esc_attr__( 'Yes', 'onekorse-pro' ),
                                    'off' => esc_attr__( 'No', 'onekorse-pro' )
                                )
                            )
                        )
                    );

                /**
                * Option : Show Digg Sharer
                */
                    $wp_customize->add_setting(
                        ONEKORSE_CUSTOMISER_VAL . '[wdt-single-product-show-sharer-digg]', array(
                            'type' => 'option'
                        )
                    );

                    $wp_customize->add_control(
                        new OneKorse_Customize_Control_Switch(
                            $wp_customize, ONEKORSE_CUSTOMISER_VAL . '[wdt-single-product-show-sharer-digg]', array(
                                'type'    => 'wdt-switch',
                                'label'   => esc_html__( 'Show Digg Sharer', 'onekorse-pro'),
                                'section' => 'woocommerce-single-page-sociable-share-section',
                                'choices' => array(
                                    'on'  => esc_attr__( 'Yes', 'onekorse-pro' ),
                                    'off' => esc_attr__( 'No', 'onekorse-pro' )
                                )
                            )
                        )
                    );

                /**
                * Option : Show Twitter Sharer
                */
                    $wp_customize->add_setting(
                        ONEKORSE_CUSTOMISER_VAL . '[wdt-single-product-show-sharer-twitter]', array(
                            'type' => 'option'
                        )
                    );

                    $wp_customize->add_control(
                        new OneKorse_Customize_Control_Switch(
                            $wp_customize, ONEKORSE_CUSTOMISER_VAL . '[wdt-single-product-show-sharer-twitter]', array(
                                'type'    => 'wdt-switch',
                                'label'   => esc_html__( 'Show Twitter Sharer', 'onekorse-pro'),
                                'section' => 'woocommerce-single-page-sociable-share-section',
                                'choices' => array(
                                    'on'  => esc_attr__( 'Yes', 'onekorse-pro' ),
                                    'off' => esc_attr__( 'No', 'onekorse-pro' )
                                )
                            )
                        )
                    );

                /**
                * Option : Show LinkedIn Sharer
                */
                    $wp_customize->add_setting(
                        ONEKORSE_CUSTOMISER_VAL . '[wdt-single-product-show-sharer-linkedin]', array(
                            'type' => 'option'
                        )
                    );

                    $wp_customize->add_control(
                        new OneKorse_Customize_Control_Switch(
                            $wp_customize, ONEKORSE_CUSTOMISER_VAL . '[wdt-single-product-show-sharer-linkedin]', array(
                                'type'    => 'wdt-switch',
                                'label'   => esc_html__( 'Show LinkedIn Sharer', 'onekorse-pro'),
                                'section' => 'woocommerce-single-page-sociable-share-section',
                                'choices' => array(
                                    'on'  => esc_attr__( 'Yes', 'onekorse-pro' ),
                                    'off' => esc_attr__( 'No', 'onekorse-pro' )
                                )
                            )
                        )
                    );

                /**
                * Option : Show Pinterest Sharer
                */
                    $wp_customize->add_setting(
                        ONEKORSE_CUSTOMISER_VAL . '[wdt-single-product-show-sharer-pinterest]', array(
                            'type' => 'option'
                        )
                    );

                    $wp_customize->add_control(
                        new OneKorse_Customize_Control_Switch(
                            $wp_customize, ONEKORSE_CUSTOMISER_VAL . '[wdt-single-product-show-sharer-pinterest]', array(
                                'type'    => 'wdt-switch',
                                'label'   => esc_html__( 'Show Pinterest Sharer', 'onekorse-pro'),
                                'section' => 'woocommerce-single-page-sociable-share-section',
                                'choices' => array(
                                    'on'  => esc_attr__( 'Yes', 'onekorse-pro' ),
                                    'off' => esc_attr__( 'No', 'onekorse-pro' )
                                )
                            )
                        )
                    );

            /**
            * Follow
            */

                /**
                * Option : Follow Description
                */
                    $wp_customize->add_setting(
                        ONEKORSE_CUSTOMISER_VAL . '[wdt-single-product-show-follow-description]', array(
                            'type' => 'option'
                        )
                    );

                    $wp_customize->add_control(
                        new OneKorse_Customize_Control_Switch(
                            $wp_customize, ONEKORSE_CUSTOMISER_VAL . '[wdt-single-product-show-follow-description]', array(
                                'type'    => 'wdt-description',
                                'label'   => esc_html__( 'Note :', 'onekorse-pro'),
                                'section' => 'woocommerce-single-page-sociable-follow-section',
                                'description'   => esc_html__( 'This option is applicable only for WooCommerce "Custom Template".', 'onekorse-pro'),
                            )
                        )
                    );

                    $social_follow = array (
                        'delicious'   => esc_html__('Delicious', 'onekorse-pro'),
                        'deviantart'  => esc_html__('Deviantart', 'onekorse-pro'),
                        'digg'        => esc_html__('Digg', 'onekorse-pro'),
                        'dribbble'    => esc_html__('Dribbble', 'onekorse-pro'),
                        'envelope'    => esc_html__('Envelope', 'onekorse-pro'),
                        'facebook'    => esc_html__('Facebook', 'onekorse-pro'),
                        'flickr'      => esc_html__('Flickr', 'onekorse-pro'),
                        'google-plus' => esc_html__('Google Plus', 'onekorse-pro'),
                        'instagram'   => esc_html__('Instagram', 'onekorse-pro'),
                        'lastfm'      => esc_html__('Lastfm', 'onekorse-pro'),
                        'linkedin'    => esc_html__('Linkedin', 'onekorse-pro'),
                        'myspace'     => esc_html__('Myspace', 'onekorse-pro'),
                        'pinterest'   => esc_html__('Pinterest', 'onekorse-pro'),
                        'reddit'      => esc_html__('Reddit', 'onekorse-pro'),
                        'rss'         => esc_html__('RSS', 'onekorse-pro'),
                        'skype'       => esc_html__('Skype', 'onekorse-pro'),
                        'stumbleupon' => esc_html__('Stumbleupon', 'onekorse-pro'),
                        'tumblr'      => esc_html__('Tumblr', 'onekorse-pro'),
                        'twitter'     => esc_html__('Twitter', 'onekorse-pro'),
                        'viadeo'      => esc_html__('Viadeo', 'onekorse-pro'),
                        'vimeo'       => esc_html__('Vimeo', 'onekorse-pro'),
                        'yahoo'       => esc_html__('Yahoo', 'onekorse-pro'),
                        'youtube'     => esc_html__('Youtube', 'onekorse-pro')
                    );

                    foreach($social_follow as $socialfollow_key => $socialfollow) {

                        $wp_customize->add_setting(
                            ONEKORSE_CUSTOMISER_VAL . '[wdt-single-product-show-follow-'.$socialfollow_key.']', array(
                                'type' => 'option'
                            )
                        );

                        $wp_customize->add_control(
                            new OneKorse_Customize_Control_Switch(
                                $wp_customize, ONEKORSE_CUSTOMISER_VAL . '[wdt-single-product-show-follow-'.$socialfollow_key.']', array(
                                    'type'    => 'wdt-switch',
                                    'label'   => sprintf(esc_html__('Show %1$s Follow', 'onekorse-pro'), $socialfollow),
                                    'section' => 'woocommerce-single-page-sociable-follow-section',
                                    'choices' => array(
                                        'on'  => esc_attr__( 'Yes', 'onekorse-pro' ),
                                        'off' => esc_attr__( 'No', 'onekorse-pro' )
                                    )
                                )
                            )
                        );

                        $wp_customize->add_setting(
                            ONEKORSE_CUSTOMISER_VAL . '[wdt-single-product-follow-'.$socialfollow_key.'-link]', array(
                                'type' => 'option'
                            )
                        );

                        $wp_customize->add_control(
                            new OneKorse_Customize_Control(
                                $wp_customize, ONEKORSE_CUSTOMISER_VAL . '[wdt-single-product-follow-'.$socialfollow_key.'-link]', array(
                                    'type'       => 'text',
                                    'section'    => 'woocommerce-single-page-sociable-follow-section',
                                    'input_attrs' => array(
                                        'placeholder' => sprintf(esc_html__('%1$s Link', 'onekorse-pro'), $socialfollow)
                                    ),
                                    'dependency' => array ( 'wdt-single-product-show-follow-'.$socialfollow_key, '==', '1' )
                                )
                            )
                        );

                    }

        }

    }

}


if( !function_exists('onekorse_shop_customizer_single_social_share_and_follow') ) {
	function onekorse_shop_customizer_single_social_share_and_follow() {
		return OneKorse_Shop_Customizer_Single_Social_Share_And_Follow::instance();
	}
}

onekorse_shop_customizer_single_social_share_and_follow();