<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/* if ( ! class_exists( 'Tribe__Events__Main' ) ) {
    exit; // Exit if accessed directly.
}
 */
class WeDesignTech_Widget_Base_Events {

	private static $_instance = null;

	private $cc_layout;
	private $cc_style;

	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	function __construct() {

		// Initialize depandant class
			$this->cc_layout = new WeDesignTech_Common_Controls_Layout('both');
			$this->cc_style = new WeDesignTech_Common_Controls_Style();

	}

	public function name() {
		return 'wdt-events';
	}

	public function title() {
		return esc_html__( 'Events', 'wdt-elementor-addon' );
	}

	public function icon() {
		return 'eicon-apps';
	}

	public function init_styles() {
		return array_merge(
			$this->cc_layout->init_styles(),
			array (
				$this->name() =>  WEDESIGNTECH_ELEMENTOR_ADDON_DIR_URL.'inc/widgets/events/assets/css/style.css'
			)
		);
	}

	public function init_inline_styles() {
		if(!\Elementor\Plugin::$instance->preview->is_preview_mode()) {
			return array (
				$this->name() => $this->cc_layout->get_column_css()
			);
		}
		return array ();
	}

	public function init_scripts() {
		return array_merge(
			$this->cc_layout->init_scripts(),
			array (
				'jquery-downcount' => WEDESIGNTECH_ELEMENTOR_ADDON_DIR_URL . 'inc/widgets/events/assets/js/jquery.downcount.js',
				$this->name() =>  WEDESIGNTECH_ELEMENTOR_ADDON_DIR_URL . 'inc/widgets/events/assets/js/scripts.js'
			)
		);
	}

	public function create_elementor_controls($elementor_object) {

		$elementor_object->start_controls_section( 'wdt_section_settings', array(
			'label' => esc_html__( 'Events Settings', 'wdt-elementor-addon'),
		) );

			$elementor_object->add_control( 'query_posts_by', array(
				'type'    => \Elementor\Controls_Manager::SELECT,
				'label'   => esc_html__('Query posts by', 'wdt-elementor-addon'),
				'default' => 'ids',
				'options' => array(
					// 'category'  => esc_html__('From Category (for Posts only)', 'wdt-elementor-addon'),
					'ids'       => esc_html__('By Specific IDs', 'wdt-elementor-addon'),
				)
			) );

			$elementor_object->add_control( '_post_ids', array(
				'label'       => esc_html__( 'Select Specific Posts', 'wdt-elementor-addon' ),
				'type'        => \Elementor\Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple'    => true,
				'options'     => $this->wdt_event_post_ids(),
				'condition' => array( 'query_posts_by' => 'ids' )
			) );

			$elementor_object->add_control( 'limit', array(
				'label'   => esc_html__('Limit', 'wdt-elementor-addon'),
				'type'    => \Elementor\Controls_Manager::SLIDER,
				'range'   => array(
					'px' => array( 'min' => 1, 'max' => 10, 'step' => 1 )
				),
				'separator' => 'before',
				'default' => array(
					'size' => 4
				)
        	) );

			$elementor_object->add_control( 'enable_days_count', array(
				'label'   => esc_html__('Enable Days Counter', 'wdt-elementor-addon'),
				'type'    => \Elementor\Controls_Manager::SWITCHER,
				'frontend_available' => true,
				'default'            => 'true',
				'return_value'       => 'true'
        	) );

		$elementor_object->end_controls_section();

		$this->cc_layout->get_controls($elementor_object);

	}

	public function render_html($widget_object, $settings) {

		if($widget_object->widget_type != 'elementor') {
			return;
		}

		$output = '';

		$classes = array ();

        $settings['module_id'] = $widget_object->get_id();
        $settings['module_class'] = 'events';
        $settings['classes'] = $classes;
        $this->cc_layout->set_settings($settings);
        $module_layout_class = $this->cc_layout->get_item_class();

        $events_arg = array (
            'start_date' => 'now',
			'post__in' 		 => ( isset($settings['_post_ids']) && !empty($settings['_post_ids']) ? $settings['_post_ids'] : '' ),
            'posts_per_page' => (isset($settings['limit']['size']) && !empty($settings['limit']['size'])) ? $settings['limit']['size'] : 4
        );
        $events_list = tribe_get_events($events_arg);

        if(is_array($events_list) && !empty($events_list)) {
            $output .= $this->cc_layout->get_wrapper_start();

                foreach($events_list as $event_item) {
                    $event_id = $event_item->ID;
                    $event_title = $event_item->post_title;
					$event_date = $event_item->event_date;

					$current_date = strtotime( date( 'Y-m-d H:i:s' ) );
					$event_date_con = strtotime( date( $event_date ) );
					if ( $event_date_con < $current_date ) {
						return;
					}

                    $output .= '<div class="wdt-event-item '.esc_attr($module_layout_class).'">';
                        if(has_post_thumbnail($event_id)) {
                            $output .= '<div class="wdt-event-item-media">';
								$output .= '<a href="'.get_permalink($event_id).'">';
                            	    $output .= get_the_post_thumbnail($event_id, 'full', array ('title' => $event_title));
								$output .= '</a>';
                            $output .= '</div>';
                        }
						$output .= '<div class="wdt-event-meta-details">';
							$output .= '<h2><a href="'.get_permalink($event_id).'">'.$event_title.'</a></h2>';						
							$output .=  '<p><span>'.tribe_get_country($event_id).'</span>' .tribe_get_start_date($event_id ,$display_time = true, $date_format = 'F j Y', $timezone = null ). ' - ' .tribe_get_end_date($event_id ,$display_time = true, $date_format = 'F j Y', $timezone = null ).'</p>';

							// Daily countdown timer
							if( $settings['enable_days_count'] ) {
								$output .= '<div class="wdt-events-countdown-holder">';
									$output .= '<div class="wdt-events-downcount" data-date="'.esc_attr( date( 'm/d/Y H:i:s', $event_date_con ) ).'" data-offset="0">';
										$output .= '<div class="wdt-counter-wrapper">';
											$output .= '<div class="counter-icon-wrapper">';
												$output .= '<div class="wdt-counter-number days">00</div>';
											$output .= '</div>';
											$output .= '<h3 class="title">'.esc_html__('Days', 'wdt-elementor-addon').'</h3>';
										$output .= '</div>';
										$output .= '<div class="wdt-counter-wrapper">';
											$output .= '<div class="counter-icon-wrapper">';
												$output .= '<div class="wdt-counter-number hours">00</div>';
											$output .= '</div>';
											$output .= '<h3 class="title">'.esc_html__('Hrs', 'wdt-elementor-addon').'</h3>';
										$output .= '</div>';
										$output .= '<div class="wdt-counter-wrapper">';
											$output .= '<div class="counter-icon-wrapper">';
												$output .= '<div class="wdt-counter-number minutes">00</div>';
											$output .= '</div>';
											$output .= '<h3 class="title">'.esc_html__('Mins', 'wdt-elementor-addon').'</h3>';
										$output .= '</div>';
										$output .= '<div class="wdt-counter-wrapper last">';
											$output .= '<div class="counter-icon-wrapper">';
												$output .= '<div class="wdt-counter-number seconds">00</div>';
											$output .= '</div>';
											$output .= '<h3 class="title">'.esc_html__('Secs', 'wdt-elementor-addon').'</h3>';
										$output .= '</div>';
									$output .= '</div>';
								$output .= '</div>';
							}

						$output .= '</div>';
						$output .= '<div class="wdt-event-cost-details">';
							$output .=  '<p><span class="wdt-event-meta-cost">'.tribe_get_cost( $event_id, true ).'</span></p>';
							$output .= '<a href="'.get_permalink($event_id).'" class="wdt-event-item-button wdt-button"><span class="wdt-event-button-label">'.esc_html__('Book Tickets', 'wdt-elementor-addon').'</span></a>';
						$output .= '</div>';
					$output .= '</div>';
                }

                $output .= $this->cc_layout->get_column_edit_mode_css();
            $output .= $this->cc_layout->get_wrapper_end();
        }

		return $output;

	}

	public function wdt_event_post_ids(){
		$posts = get_posts( array(
			'post_type'   => 'tribe_events',
			'post_status' => 'publish',
			'numberposts' => -1
		));

		if ( ! empty( $posts ) && ! is_wp_error( $posts ) ){
			foreach ( $posts as $post ) {
				$options[ $post->ID ] = $post->post_title;
			}
		}

		return $options;
	}

}

if( !function_exists( 'wedesigntech_widget_base_events' ) ) {
    function wedesigntech_widget_base_events() {
        if ( class_exists( 'Tribe__Events__Main' ) ) {
            return WeDesignTech_Widget_Base_Events::instance();
        }
    }
}